# 第二章 开源开发者发展现状
开源软件在全球技术发展中已成为不可或缺的一部分，并对技术创新、合作和贡献产生了深远影响。开源为开发者提供了一个具有开放性、透明性的自由交流、分享、协作的平台。与此同时，开发者立足于项目、企业、社区、基金会，通过编写、测试和优化代码，以及运营、治理等方式，深度参与开源的创造、贡献、建设，在开源项目的成功、社区的生态繁荣、百业同鸣历程中起着至关重要的作用。

## 2.1	 中国开源开发者规模、增速及发展趋势

### 1）开发者基本画像
中国开源开发者的数量呈现出快速增长的趋势。据GitHub 2022年数据统计，GitHub平台开发者数量达到9400万开发者，开发者同比增长 27%，新增用户超过2050万，全球有90%的公司在使用开源。

根据GitHub报告，中国是全球开发者人数最多的国家之一。随着中国技术行业的蓬勃发展和对开源的持续重视，越来越多的开发者加入到开源社区中，贡献自己的代码和技术。
![](https://img-blog.csdnimg.cn/38d4efb98a4647198a51d395f9d5fb8d.png)

数据显示，按照地区或国家来划分，中国开源开发者的增速令人瞩目。2021年在全球总开发者数量中，美国开发者最多，中国排名第二，共有超过755万的开发者。2022年，中国开发者数量占GitHub新增开发者数百分比为15.6%。据2023 年 4 月工信部透露，目前我国开源软件开发者数量突破 800 万。中国开发者在GitHub上的活跃度和贡献度逐年提升。越来越多的中国开发者开始关注开源项目，积极参与到开源社区中，通过贡献代码、提交问题和解决方案等方式，为开源项目的发展做出贡献。开源已经为我们创造了一个非常不同的世界。

![](https://img-blog.csdnimg.cn/880e5be67dec42908544e31f0ec57d16.png)

据 CSDN GitCode、PingCAP OSSInsight、北京大学软件与微电子学院荆琦副教授联合出品的《2022 中国开源贡献度报告》统计，中国拥有占全球30%的最大规模开发者群体，开源增长空间和潜力巨大。而作为科技创新的重要模式，开源得到普遍重视，已经列入我国重大发展战略之列。
该报告以两年作为统计期，全球贡献者（以邮箱统计）共计 213,982人，贡献者地区为中国的用户数为10,691人（仅包括填写地区的中国贡献者），预计中国开发者占总贡献者的数量约为9.5%（假设未填写地区的和填写地区的中国贡献者比例分布一致）。![在这里插入图片描述](https://img-blog.csdnimg.cn/7d7bbe3c45434561a19e33e076a06584.png)

基于国内主流的技术社区及论坛的注册用户数，观察中国开发者的整体增长趋势时发现，中国开发者社区CSDN，拥有注册账号是8700 万，而注册用户在排重以后是 4200 万，相较 2021年新增了 600 万用户。这新增的 600 万用户里，新增用户中有 60% 都是大学生和高中生，高校计算机专业学生覆盖度 90%，非常的年轻化。

根据开源社区 Gitee 统计，2022 年 Gitee 新增了 200 万的用户，平台仓库数量达到 2500 万，新仓库数量为 480 万，总用户数达到 1000 万。
![](https://img-blog.csdnimg.cn/2fae4b91e2d646869fe03c37958fa0bd.png)

### 2）开发者行业、地域、技术特点等
根据CSDN发布的《2022-2023 中国开发者调查报告》显示，我们将开发者根据年龄范围划分成三类发现，30岁以下的开发者人数占71%，本科及以上学历占8成，89%的开发者都是男性。软件行业涵盖了国内近半数开发者。40岁以下的开发者从事后端开发的比例最高。40岁以上开发者主要担任技术经理以及架构师的职位，所属行业重点分布在互联网、软件、教育领域。

![在这里插入图片描述](https://img-blog.csdnimg.cn/89105270653945e19eea3b5255773ef6.png)

全国超过40%的开发者工作在一线城市（其中以北京、上海、广州、深圳为主）。北京、广东是开发者聚集较多的地域，占全国总数28.2%。上海、江苏地区的开发者占比数量处于第二梯队，占全国总数的15.1%。

![在这里插入图片描述](https://img-blog.csdnimg.cn/98aa0db66a2b404c9aa14f681ef875e8.png)

开源正在吞噬世界，在日常的开发工作中，无可避免地要使用到开源软件，数据显示，96%的开发者正在使用开源软件，仅有2%的开发者表示从未使用开源软件。

![在这里插入图片描述](https://img-blog.csdnimg.cn/c7d4d0a1d6584df690e73d66240d8288.png)

图表118 开发者是否使用过开源软件比例
当然，开发者在使用开源开源的过程中，也参与开源、回馈开源。相较去年42%的开发者参与过开源，今年有较大幅的增长，49%的开发者参与过开源项目，接近一半的开发者加入了开源的大队伍。
![在这里插入图片描述](https://img-blog.csdnimg.cn/ccfaec9708c14e5eba62fce0cf4d5316.png)

图表119 开发者参与开源项目的比例

67%的开发者每周在开源上投入的时间不超过5小时，随着开源的发展，有更多的人从事开源相关的工作，数据显示，有4%的开发者每周在开源上投入30小时以上。

![在这里插入图片描述](https://img-blog.csdnimg.cn/e5f09ba4702044fea7e9521aafade0c1.png)


图表123 开发者在开源上花费的时间

在开源项目的贡献上，主要还是通过代码和文档的贡献，在参与过开源项目的开发者中，有72.9%的开发者有代码贡献，49%开发者有文档贡献。

![在这里插入图片描述](https://img-blog.csdnimg.cn/931c005ec6b3480ea77a10d2876f55f5.png)

图表126 开发者参与开源的方式
互联网产品是开发者首次接触开源项目的类别，占比36%，越来越多的产品正在使用开源项目进行构建。
![在这里插入图片描述](https://img-blog.csdnimg.cn/e907c89298594f639959426aa8a3edbe.png)

图表127 开发者首次接触开源项目类别
在开源项目中，Java依然是最常用的开发语言，有41%的开发者表示，在开源项目中经常会使用到。其次是Python，占比27%。
![在这里插入图片描述](https://img-blog.csdnimg.cn/f4ac449747cc41db90aabe328b78da0b.png)

图表128 开源中常用的开发语言
国内的开源项目，基本都会建立一个QQ群，用于社区成员交流。数据显示，QQ群、邮件列表、微信为三大主要交流工具。

![在这里插入图片描述](https://img-blog.csdnimg.cn/54daa06af44742b8ab44d79733e82809.png)

图表129 开源社区成员交流工具


中国开源开发者在各个技术领域都有涉猎和贡献。从人工智能、大数据到区块链、云计算等领域，中国开发者在各个前沿技术的开源项目中都有积极参与和贡献。他们不仅关注国内的开源项目，也积极参与到国际开源社区中，与全球开发者共同推动技术的进步。人工智能的发展，吸引了众多开发者的目光，45%的开发者比较关注开源AI，其次是编程语言。

![开发者关注的开源技术领域](https://img-blog.csdnimg.cn/29ffb01c7c7f4715b19eef7917eb1d11.png)
随着近几年操作系统的热度提升，开发者最希望看到操作系统相关的开源项目。
![开发者最希望开源的项目](https://img-blog.csdnimg.cn/1cac500e77324f47a7493b8796e868c8.png)


## 2.2 开源开发者对开源社区、开源活动和开源项目的投入和贡献

（聚焦在各种能力诸如领导力、创新力、发现问题和解决问题的能力）
开放透明的代码和知识共享是吸引众多开发者的最大因素之一，占比55.8%。
![吸引开发者使用开源软件的因素](https://img-blog.csdnimg.cn/ea73c4731028438cbd80875a37382fb4.png)


### 1）开源社区和开源活动

中国的开源开发者社区也在不断发展壮大。越来越多的开源社区和组织在中国成立，为开发者提供了学习、交流和合作的平台。同时，一些国内知名的技术企业也在积极推动开源文化，通过开源项目和活动，促进开发者之间的合作和创新。

![在这里插入图片描述](https://img-blog.csdnimg.cn/0ead793ddb6a4ffdb3e701542288c285.png#pic_center)

社区创始年表

![在这里插入图片描述](https://img-blog.csdnimg.cn/2471716079de45e99b63ba40b2cda84f.png#pic_center)
![在这里插入图片描述](https://img-blog.csdnimg.cn/a6634b117ddf466ba91d161a3205fe87.png#pic_center)




### 2）开源项目

中国开发者主导的开源项目占全球12.5%

《2022 中国开源贡献度报告》
本次报告中，根据每个项目中提交是否为中国开发者的提交，按照大于标注为中国地区开发者的提交占比超过40%为主要标准，外加CSDN、Gitee等国内社区标签信息为参考，确认674个项目为中国开发者主导的项目，占比约12.5%。
在这里插入图片描述

中国开源项目走向全球：海外贡献者占比 33.7%
一个值得关注的数据是：在674个中国项目两年内收到的343,735个提交中，标注地区信息的开发者提交数为205,528。其中，中国开发者的提交136,350，占比66.3%。国际开发者提交69,178，占比33.7%。国际开发者高于三成的参与率，说明中国的开源项目正在走向全球，引起了全球开发者的关注。

尽管大多开源项目还是以国际公司为主导推出，但中国开源势力已经开始登上国际化的舞台。报告根据GitHub Event的数据，汇总出“中国开源项目 Top20”（注：由于本轮发布项目排行数据主要参考GitHub中Event数据，目前在GitHub中没有数据的项目尚未计算在内，例如OpenHarmony、openEuler、 MindSpore等）。




### 3）其它

## 2.3 开源开发者的需求和面临的挑战

### 1）调研需求分析和建议

从项目来看，主流开源项目国内席位稀少，只有两个项目上榜。

其中，pytorch超过tensorflow位列第一，tensorflow、bootstrap、vue、react位列二、三、四、五。中国项目ant-design和vue-element-admin上榜，排名17和26，均为前端项目。
![国际开源项目TOP 50](https://img-blog.csdnimg.cn/5f02a6e35431472eb510a3d3ca48398b.png)




从开发者角度来看，开发者对于开源协议和内源的了解程度不够


需要加大宣传和教育的力度。

除了对外的开源，各公司也在开始发力内源（InnerSource），加速公司类部代码共享。数据显示，仅14%的开发者对其有较深入的了解。要想更好的发展内源，各公司还需要加大投入。

![开发者对内源的了解程度](https://img-blog.csdnimg.cn/b43feb32d42b4da5af494377b14eae35.png)


开源协议是开源的重中之重，但依然有21.4% 的开发者在使⽤开源项⽬时，没有关注过开源协议就直接进⾏使⽤，这可能使自己陷入开源合规风险。在开发者中，了解最多的是Apache许可证，占⽐43.8%，其次是MIT许可证。 
![开发者了解的开源许可证](https://img-blog.csdnimg.cn/f057f64b35e74b27be3321d4d2e2c177.png)

目前，国内外有很多公司都建立了开源办公室，主要职能是设置代码使用、分发、选择、审计相关政策、培训开发人员等。到目前为止，还有超过半数的开发者完全没有听过开源办公室。

![开发者对开源办公室（OSPO）的了解程度](https://img-blog.csdnimg.cn/dc402437baad41a083323767e24b424e.png)


63%的开发者表示未曾在开源中获得收入。未获得收入。

![开发者在开源上获得的收入](https://img-blog.csdnimg.cn/7d78dbecc2454104a3e51af8960ae09d.png)
超过1/5的开发者，对License毫不关心，虽然符合预期，却依然令人遗憾。国内还是有不少开发者认为开源仅仅与技术相关，仅仅与代码相关，却忽略了License和Copyright的重要性。这样的做法会给自己所在的企业带来极大的风险！
 
另一个数据，就更加令人遗憾了，还是有许多参与开源的开发者，依然在用爱发电，依然靠着自己的热爱在勉力支撑，这样的状况，已经到了迫切需要改变的时候了。否则，下一个core-js的悲剧，依然会发生。


同时，开源社区中的交流工具和开源领域的发展方向也是需要关注和改善的。这些问题需要开源社区和相关企业共同努力解决，从而更好地推动整个行业向更加开放、透明、合作的方向发展。

### 2）建议

对于中国开源开发者面临的挑战，以下是一些建议和分享：

1. 提升国际化影响力：

- 鼓励和支持中国开源开发者积极参与和贡献到全球主流开源项目中。提供培训、指导和资源，帮助他们融入全球开源社区。
- 推动中国开源项目在全球开源社区中的知名度和影响力，提高其在全球主流开源项目中的席位。

2. 加强内源理解和实践：
- 提供培训和教育资源，帮助开发者深入理解内源的概念和实践，并在项目开发中积极采用内源模式。
- 鼓励开源社区组织内源活动和分享经验，促进内源理念的传播和应用。

3. 加强开源文化的推广：

- 加大宣传力度，提高开发者对开源办公室的认知。举办开源活动、研讨会和培训，让更多开发者了解开源文化和实践的重要性。
- 建立开源社区的合作机制，促进开源办公室与开发者之间的联系和交流，共同推动开源的发展。

4. 开发者收入机制的改进：

- 探索多元化的开源项目收入模式，例如基于赞助、捐赠、咨询服务和定制开发等方式，为开源开发者提供更多的收入来源。
- 建立合理的激励机制，鼓励开发者在开源项目中的贡献，并将其贡献价值化，以吸引更多开发者积极参与和贡献。

总的来说，提升中国开源开发者的国际化影响力、加强内源理解和实践、推广开源文化以及改进开发者收入机制，这些努力将有助于解决中国开源开发者面临的挑战，并推动中国开源生态系统的发展。





内容来源：

国际数据

- GitHub：https://octoverse.github.com/

- Stack Overflow：https://survey.stackoverflow.co/2022/

开源基金会：

- Apache 软件基金会
- Linux 基金会
- CNCF 基金会

中国：

- 开放原子开源基金会
- 重庆天工开物开源基金

技术社区、技术媒体

- CSDN

2022-2023 中国开发者大调查：开发者现状
2022-2023 开源开发者
CSDN 平台上开源的数据及分析
https://tf17ro.yuque.com/tf17ro/ve27h2/uociru4z94dgg2hd

开源榜单：https://blog.csdn.net/csdnnews/article/details/127510316

- OSChina & Gitee（林日华提供）

2022 中国开源开发者报告（发布时间：2023-02-06）

https://gitee.com/report/china-open-source-2022/

- 思否

- InfoQ

- 开源社

开源报告：https://kaiyuanshe.cn/article/2022-China-Open-Source-Annual-Report

中国开源地图：https://kaiyuanshe.cn/organization


